﻿Option Strict On
Option Explicit On
Option Infer Off

Public Class Form1

    Dim dragDropSource As Object = Nothing

    Dim indeksSource As Integer = -1
    Const promienProgowy As Integer = 30
    Dim przeciaganie As Boolean = False
    Dim polozenieMyszy As Point = New Point()

    Public Sub New()

        InitializeComponent()

        'Wypełnianie list
        For i As Integer = 1 To 10
            ListBox1.Items.Add("lista 1, pozycja " & i.ToString())
            ListBox2.Items.Add("lista 2, pozycja " & i.ToString())
        Next
    End Sub

    Private Sub ListBox1_MouseDown(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles ListBox2.MouseDown, ListBox1.MouseDown
        Dim lbSender As ListBox = CType(sender, ListBox)
        Dim indeks As Integer = lbSender.IndexFromPoint(e.X, e.Y)
        dragDropSource = sender 'przechowanie referencji dla DragOver
        indeksSource = indeks

        If e.Button = MouseButtons.Left And indeks <> -1 Then
            przeciaganie = True
            polozenieMyszy.X = e.X
            polozenieMyszy.Y = e.Y
        End If

        'usunięte polecenie czyszczące referencję dragDropSource
    End Sub

    Private Sub ListBox1_DragOver(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles ListBox2.DragOver, ListBox1.DragOver
        If sender Is dragDropSource Then
            e.Effect = DragDropEffects.None
        ElseIf (e.KeyState And 8) = 8 Then
            e.Effect = DragDropEffects.Copy 'z CTRL
        Else
            e.Effect = DragDropEffects.Move
        End If
    End Sub

    Private Sub ListBox1_DragDrop(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles ListBox2.DragDrop, ListBox1.DragDrop
        Dim lbSender As ListBox = CType(sender, ListBox)
        Dim indeks As Integer = lbSender.IndexFromPoint(lbSender.PointToClient(New Point(e.X, e.Y)))
        If indeks = -1 Then indeks = lbSender.Items.Count
        lbSender.Items.Insert(indeks, e.Data.GetData(DataFormats.Text).ToString())
    End Sub

    Private Sub ListBox1_MouseMove(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles ListBox2.MouseMove, ListBox1.MouseMove
        Dim lbSource As ListBox = CType(dragDropSource, ListBox)
        If przeciaganie Then
            If (indeksSource > -1) Then lbSource.SelectedIndex = indeksSource
            Dim dx As Integer = e.X - polozenieMyszy.X
            Dim dy As Integer = e.Y - polozenieMyszy.Y
            If ((dx * dx + dy * dy) > promienProgowy * promienProgowy) Then
                'przeniesione z listBox1_MouseDown
                Dim operacja As DragDropEffects = lbSource.DoDragDrop(lbSource.Items(indeksSource), DragDropEffects.Copy Or DragDropEffects.Move)
                If operacja = DragDropEffects.Move Then lbSource.Items.RemoveAt(indeksSource)
                przeciaganie = False
                dragDropSource = Nothing
            End If
        End If
    End Sub

    Private Sub ListBox1_MouseUp(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles ListBox2.MouseUp, ListBox1.MouseUp
        przeciaganie = False
    End Sub
End Class
